<?php

/***************************************************************************
 *
 *    ougc Awards plugin (/inc/languages/english/ougc_awards.lang.php)
 *    Author: Omar Gonzalez
 *    Copyright: © 2012-2020 Omar Gonzalez
 *
 *    Website: https://ougc.network
 *
 *    Manage a powerful awards system for your community.
 *
 ***************************************************************************
 ****************************************************************************
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/

$l = [
    'ougcAwards' => 'Premios',

    'ougcAwardsPageNavigation' => 'Premios',
    'ougcAwardsNoReason' => 'No se especificó ninguna razón.',
    'ougcAwardsGlobalMenu' => 'Premios',
    'ougcAwardsWelcomeLinkText' => 'Ver Mis Premios',
    'ougcAwardsWelcomeLinkTextSection' => 'Ver Mis Premios en {1}',

    'ougcAwardsButtonRequest' => 'Solicitar',

    'ougcAwardsGlobalNotificationsRequests' => 'Hay {1} solicitudes de premios esperando aprobación.',

    'ougcAwardsRedirectRequestAccepted' => 'Solicitud de premio aceptada con éxito.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectRequestRejected' => 'Solicitud de premio rechazada con éxito.<br />Ahora serás redirigido de vuelta.',

    'ougcAwardsControlPanelRequestsButtonAccept' => 'Aceptar',
    'ougcAwardsControlPanelRequestsButtonReject' => 'Rechazar',

    'ougcAwardsControlPanelRequestsFilterTitle' => 'Filtrar',
    'ougcAwardsControlPanelRequestsFilterStatus' => 'Estado',
    'ougcAwardsControlPanelRequestsFilterStatusOpen' => 'Abierto',
    'ougcAwardsControlPanelRequestsFilterStatusAccepted' => 'Aceptado',
    'ougcAwardsControlPanelRequestsFilterStatusRejected' => 'Rechazado',

    'ougcAwardsErrorRequestsNoneSelected' => 'No se seleccionaron premios.',
    'ougcAwardsErrorUploadFailed' => 'La carga de la imagen del premio falló.',
    'ougcAwardsErrorUploadInvalidType' => 'El tipo de imagen del premio es inválido.',
    'ougcAwardsErrorUploadReize' => 'El cambio de tamaño de la imagen del premio falló.',
    'ougcAwardsErrorUploadSize' => 'El tamaño de la imagen del premio es inválido.',

    'ougcAwardsControlPanelNavigation' => 'Premios',
    'ougcAwardsControlPanelButtonNewCategory' => 'Nueva Categoría',

    'ougcAwardsControlPanelNewCategoryTitle' => 'Nueva Categoría',
    'ougcAwardsControlPanelNewCategoryTableTitle' => 'Nueva Categoría',
    'ougcAwardsControlPanelNewCategoryTableDescription' => 'Utiliza el formulario a continuación para crear una nueva categoría.',
    'ougcAwardsControlPanelNewCategoryName' => 'Nombre',
    'ougcAwardsControlPanelNewCategoryNameDescription' => 'Selecciona un nombre corto para esta categoría.',
    'ougcAwardsControlPanelNewCategoryDescription' => 'Descripción',
    'ougcAwardsControlPanelNewCategoryDescriptionDescription' => 'Selecciona una descripción corta para esta categoría.',
    'ougcAwardsControlPanelNewCategoryAllowRequests' => 'Permitir Solicitudes de Usuarios',
    'ougcAwardsControlPanelNewCategoryAllowRequestsDescription' => 'Permitir a los usuarios solicitar esta categoría.',
    'ougcAwardsControlPanelNewCategoryEnabled' => 'Habilitado',
    'ougcAwardsControlPanelNewCategoryEnabledDescription' => 'Habilitar esta categoría.',
    'ougcAwardsControlPanelNewCategoryDisplayOrder' => 'Orden de Visualización',
    'ougcAwardsControlPanelNewCategoryDisplayOrderDescription' => 'Selecciona el orden de visualización para esta categoría.',
    'ougcAwardsControlPanelNewCategoryOutputInCustomSection' => 'Mostrar en Seccion Personalizada',
    'ougcAwardsControlPanelNewCategoryOutputInCustomSectionDescription' => 'Habilitar esto para mostrar premios de esta categoría en su seccion personalizada.',
    'ougcAwardsControlPanelNewCategoryHideInMainPage' => 'Ocultar en Pagina Principal',
    'ougcAwardsControlPanelNewCategoryHideInMainPageDescription' => 'Habilitar esto para ocultar en la pagina principal si el usuario no es un moderator o un propietario de la categoria',
    'ougcAwardsControlPanelNewCategoryButton' => 'Crear Categoría',

    'ougcAwardsControlPanelEditCategoryTitle' => 'Editar Categoría',
    'ougcAwardsControlPanelEditCategoryTableTitle' => 'Editar Categoría',
    'ougcAwardsControlPanelEditCategoryTableDescription' => 'Utiliza el formulario a continuación para actualizar la categoría seleccionada.',
    'ougcAwardsControlPanelEditCategoryButton' => 'Actualizar Categoría',

    'ougcAwardsControlPanelTitle' => 'Premios',
    'ougcAwardsControlPanelAward' => 'Premio',
    'ougcAwardsControlPanelName' => 'Nombre',
    'ougcAwardsControlPanelDescription' => 'Descripción',
    'ougcAwardsControlPanelEmpty' => 'Actualmente no hay premios para mostrar.',
    'ougcAwardsControlPanelAwardViewOwners' => 'Ver Propietarios',
    'ougcAwardsControlPanelAwardNewAward' => 'Nuevo Premio',
    'ougcAwardsControlPanelAwardEditCategory' => 'Editar',
    'ougcAwardsControlPanelAwardDeleteCategory' => 'Eliminar',
    'ougcAwardsControlPanelEnabled' => 'Habilitado',
    'ougcAwardsControlPanelDisplayOrder' => 'Orden de Visualización',
    'ougcAwardsControlPanelOptions' => 'Opciones',
    'ougcAwardsControlPanelRequest' => 'Solicitar',
    'ougcAwardsControlPanelViewUsers' => 'Ver Usuarios',
    'ougcAwardsControlPanelViewOwners' => 'Ver Propietarios',
    'ougcAwardsControlPanelViewRequests' => 'Ver Solicitudes',
    'ougcAwardsControlPanelEditAward' => 'Editar Premio',
    'ougcAwardsControlPanelDeleteAward' => 'Eliminar Premio',
    'ougcAwardsControlPanelRequestAward' => 'Solicitar Premio',
    'ougcAwardsControlPanelButtonUpdate' => 'Actualizar Premios',
    'ougcAwardsControlPanelButtonNewAward' => 'Nuevo Premio',

    'ougcAwardsControlPanelNewAwardTitle' => 'Nuevo Premio',
    'ougcAwardsControlPanelNewAwardTableTitle' => 'Nuevo Premio',
    'ougcAwardsControlPanelNewAwardTableDescription' => 'Utiliza el formulario a continuación para crear un nuevo premio.',
    'ougcAwardsControlPanelNewAwardName' => 'Nombre',
    'ougcAwardsControlPanelNewAwardNameDescription' => 'Selecciona un nombre corto para este premio.',
    'ougcAwardsControlPanelNewAwardDescription' => 'Descripción',
    'ougcAwardsControlPanelNewAwardDescriptionDescription' => 'Selecciona una descripción corta para este premio.',
    'ougcAwardsControlPanelNewAwardCategory' => 'Categoría',
    'ougcAwardsControlPanelNewAwardCategoryDescription' => 'Selecciona la categoría para este premio.',
    'ougcAwardsControlPanelNewAwardImageFile' => 'Archivo de Icono',
    'ougcAwardsControlPanelNewAwardImageFileDescription' => 'Sube una imagen para este premio.',
    'ougcAwardsControlPanelNewAwardImageFileNote' => 'El icono del archivo actual será reemplazado si se sube un nuevo archivo.',
    'ougcAwardsControlPanelNewAwardImageType' => 'URL / Clase',
    'ougcAwardsControlPanelNewAwardImageTypeDescription' => 'Ingresa la ruta de la imagen o el nombre de la clase para este premio a continuación. Las siguientes variables están disponibles.<br />Deja vacío para usar el icono del archivo subido.<br /><pre style="color: darkgreen;">
{forum_url} -> URL del foro
{images_url} -> URL de las imagenes del estilo
{award_id} -> Identificador del premio
{category_id} -> Identificador de la categoria
</pre>',
    'ougcAwardsControlPanelNewAwardTemplateType' => 'Tipo de Icono',
    'ougcAwardsControlPanelNewAwardTemplateTypeDescription' => 'Selecciona qué tipo de icono usar para este premio.<br /><pre style="color: darkgreen;">
Icono de Archivo o URL: Mejor para premios de imagen (archivo).
Icono de Clase: Mejor para premios de CSS (clase).
Icono Personalizado (Avanzado): Una plantilla personalizada para este premio.
</pre>',
    'ougcAwardsControlPanelNewAwardTemplateTypeImage' => 'Icono de Archivo o URL',
    'ougcAwardsControlPanelNewAwardTemplateTypeClass' => 'Icono de Clase',
    'ougcAwardsControlPanelNewAwardTemplateTypeCustom' => 'Icono Personalizado (Avanzado)',
    'ougcAwardsControlPanelNewAwardAllowRequests' => 'Permitir Solicitudes de Usuarios',
    'ougcAwardsControlPanelNewAwardAllowRequestsDescription' => 'Permitir a los usuarios solicitar este premio.',
    'ougcAwardsControlPanelNewAwardPrivateMessage' => 'Contenido del Mensaje Privado',
    'ougcAwardsControlPanelNewAwardPrivateMessageDescription' => 'Si no está vacío, se enviará un Mensaje Privado cada vez que se otorgue este premio.<br /><pre style="color: darkgreen;">
{user_name} = Nombre de Usuario
{award_name} = Nombre del Premio
{grant_reason} = Razón
{award_icon} = Imagen
{forum_name} = Nombre del foro
</pre>',
    'ougcAwardsControlPanelNewAwardDisplayType' => 'Tipo de Visualización',
    'ougcAwardsControlPanelNewAwardDisplayTypeDescription' => 'Selecciona si este premio se mostrará en publicaciones, perfiles o ambos.',
    'ougcAwardsControlPanelNewAwardDisplayTypeBoth' => 'Ambos',
    'ougcAwardsControlPanelNewAwardDisplayTypeProfile' => 'Perfil',
    'ougcAwardsControlPanelNewAwardDisplayTypePosts' => 'Publicaciones',
    'ougcAwardsControlPanelNewAwardButton' => 'Crear Premio',

    'ougcAwardsControlPanelEditAwardTitle' => 'Editar Premio',
    'ougcAwardsControlPanelEditAwardTableTitle' => 'Editar Premio',
    'ougcAwardsControlPanelEditAwardTableDescription' => 'Utiliza el formulario a continuación para actualizar el premio seleccionado.',
    'ougcAwardsControlPanelEditAwardButton' => 'Actualizar Premio',

    'ougcAwardsControlPanelDeleteAwardTitle' => 'Eliminar Premio',
    'ougcAwardsControlPanelDeleteAwardTableTitle' => 'Eliminar Premio',
    'ougcAwardsControlPanelDeleteAwardTableDescription' => '¿Estás seguro de que deseas eliminar el premio seleccionado?',
    'ougcAwardsControlPanelDeleteAwardDetailTotalGranted' => 'Total de registros de otorgamiento de premios',
    'ougcAwardsControlPanelDeleteAwardDetailTotalOwners' => 'Total de registros de propietarios',
    'ougcAwardsControlPanelDeleteAwardDetailTotalRequests' => 'Total de registros de solicitudes',
    'ougcAwardsControlPanelDeleteAwardButton' => 'Eliminar Premio',

    'ougcAwardsControlPanelDeleteCategoryTitle' => 'Eliminar Categoría',
    'ougcAwardsControlPanelDeleteCategoryTableTitle' => 'Eliminar Categoría',
    'ougcAwardsControlPanelDeleteCategoryTableDescription' => '¿Estás seguro de que deseas eliminar la categoría seleccionada?',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalAwards' => 'Total de registros de premios',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalGranted' => 'Total de registros de otorgamiento de premios',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalCategoryOwners' => 'Total de registros de propietarios de la categoría',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalOwners' => 'Total de registros de propietarios',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalRequests' => 'Total de registros de solicitudes',
    'ougcAwardsControlPanelDeleteCategoryButton' => 'Eliminar Categoría',

    'ougcAwardsControlPanelUsersEmpty' => 'Actualmente no hay usuarios para mostrar.',

    'ougcAwardsControlPanelUsersTitle' => 'Usuarios Otorgados',
    'ougcAwardsControlPanelUsersTableTitle' => 'Usuarios Otorgados',
    'ougcAwardsControlPanelUsersTableUsername' => 'Nombre de Usuario',
    'ougcAwardsControlPanelUsersTableReason' => 'Razón',
    'ougcAwardsControlPanelUsersTableThread' => 'Tema',
    'ougcAwardsControlPanelUsersTableDate' => 'Fecha',
    'ougcAwardsControlPanelUsersTableOptions' => 'Opciones',
    'ougcAwardsControlPanelUsersTableOptionsEditGrant' => 'Editar Otorgamiento',
    'ougcAwardsControlPanelUsersRevokeButton' => 'Revocar Otorgamiento',

    'ougcAwardsControlPanelMyAwardsEmpty' => 'Actualmente no hay premios para mostrar.',

    'ougcAwardsControlPanelMyAwardsTitle' => 'Mis Premios',
    'ougcAwardsControlPanelMyAwardsTableTitle' => 'Mis Premios',
    'ougcAwardsControlPanelMyAwardsTableAward' => 'Premio',
    'ougcAwardsControlPanelMyAwardsTableName' => 'Nombre',
    'ougcAwardsControlPanelMyAwardsTableReason' => 'Razón',
    'ougcAwardsControlPanelMyAwardsTableThread' => 'Tema',
    'ougcAwardsControlPanelMyAwardsTableDate' => 'Fecha',
    'ougcAwardsControlPanelMyAwardsTableDisplay' => 'Visualización',
    'ougcAwardsControlPanelMyAwardsTableDisplayOrder' => 'Orden de Visualización',

    'ougcAwardsControlPanelCategoryOwnersEmpty' => 'Actualmente no hay usuarios para mostrar.',

    'ougcAwardsControlPanelCategoryOwnersTitle' => 'Propietarios de la Categoría',
    'ougcAwardsControlPanelCategoryOwnersTableTitle' => 'Propietarios de la Categoría',

    'ougcAwardsControlPanelCategoryOwnersForm' => 'Asignar Propietario',
    'ougcAwardsControlPanelCategoryOwnersFormDescription' => 'Utiliza el formulario a continuación para asignar nuevos propietarios a esta categoría.',
    'ougcAwardsControlPanelCategoryOwnersFormUsernames' => 'Nombres de Usuario',
    'ougcAwardsControlPanelCategoryOwnersFormButton' => 'Asignar Propietario',

    'ougcAwardsControlPanelOwnersEmpty' => 'Actualmente no hay usuarios para mostrar.',

    'ougcAwardsControlPanelOwnersTitle' => 'Propietarios',
    'ougcAwardsControlPanelOwnersTableTitle' => 'Propietarios del Premio',
    'ougcAwardsControlPanelOwnersTableUsername' => 'Nombre de Usuario',
    'ougcAwardsControlPanelOwnersTableDate' => 'Fecha',
    'ougcAwardsControlPanelOwnersTableOptions' => 'Opciones',
    'ougcAwardsControlPanelUsersTableOptionsDelete' => 'Revocar Propietario',

    'ougcAwardsControlPanelOwnersForm' => 'Asignar Propietario',
    'ougcAwardsControlPanelOwnersFormDescription' => 'Utilice el formulario a continuación para asignar nuevos propietarios a este premio.',
    'ougcAwardsControlPanelOwnersFormUsernames' => 'Nombres de Usuario',
    'ougcAwardsControlPanelOwnersFormButton' => 'Asignar Propietario',

    'ougcAwardsControlPanelGrantTable' => 'Conceder Premio',
    'ougcAwardsControlPanelGrantTableDescription' => 'Conceda este premio a los usuarios.',
    'ougcAwardsControlPanelGrantTableUsernames' => 'Nombres de Usuario',
    'ougcAwardsControlPanelGrantTableReason' => 'Razón',
    'ougcAwardsControlPanelGrantTableThread' => 'Hilo',
    'ougcAwardsControlPanelGrantButton' => 'Conceder Premio',

    'ougcAwardsControlPanelRevokeTable' => 'Revocar Premio',
    'ougcAwardsControlPanelRevokeTableDescription' => 'Revocar este premio de los usuarios.',
    'ougcAwardsControlPanelRevokeTableUsernames' => 'Nombres de Usuario',
    'ougcAwardsControlPanelRevokeButton' => 'Revocar Premio',

    'ougcAwardsControlPanelEditGrantTitle' => 'Editar Concesión',
    'ougcAwardsControlPanelEditGrantTableTitle' => 'Editar Concesión',
    'ougcAwardsControlPanelEditGrantTableDescription' => 'Utilice el formulario a continuación para editar una concesión de premio existente.',
    'ougcAwardsControlPanelEditGrantTableReason' => 'Razón de la Concesión',
    'ougcAwardsControlPanelEditGrantTableReasonDescription' => 'Seleccione una razón para conceder este premio.',
    'ougcAwardsControlPanelEditGrantTableThread' => 'Hilo de Concesión',
    'ougcAwardsControlPanelEditGrantTableThreadDescription' => 'Por favor, introduzca un hilo para asignar esta concesión.',
    'ougcAwardsControlPanelEditGrantTableDate' => 'Fecha de Concesión',
    'ougcAwardsControlPanelEditGrantTableDateDescription' => 'Modifique la marca de tiempo de la concesión.',
    'ougcAwardsControlPanelEditGrantButton' => 'Actualizar Concesión',

    'ougcAwardsControlPanelDeleteCategoryOwnersTitle' => 'Eliminar Propietario de Categoría',
    'ougcAwardsControlPanelDeleteCategoryOwnersDescription' => '¿Está seguro de que desea eliminar al propietario seleccionado?',
    'ougcAwardsControlPanelDeleteCategoryOwnersButton' => 'Eliminar Propietario de Categoría',

    'ougcAwardsControlPanelDeleteOwnersTitle' => 'Eliminar Propietario',
    'ougcAwardsControlPanelDeleteOwnersDescription' => '¿Está seguro de que desea eliminar al propietario seleccionado?',
    'ougcAwardsControlPanelDeleteOwnersButton' => 'Eliminar Propietario',

    'ougcAwardsControlPanelRequests' => 'Solicitudes de Premio',
    'ougcAwardsControlPanelRequestsTableTitle' => 'Solicitudes de Premio',

    'ougcAwardsControlPanelRequestsEmpty' => 'Actualmente no hay solicitudes para mostrar.',
    'ougcAwardsControlPanelRequestsTableAward' => 'Premio',
    'ougcAwardsControlPanelRequestsTableUsername' => 'Nombre de Usuario',
    'ougcAwardsControlPanelRequestsTableMessage' => 'Mensaje',
    'ougcAwardsControlPanelRequestsTableStatus' => 'Estado',
    'ougcAwardsControlPanelRequestsTableOptions' => 'Opciones',

    'ougcAwardsControlPanelRequestsStatusPending' => 'Pendiente',
    'ougcAwardsControlPanelRequestsStatusRejected' => 'Rechazado',
    'ougcAwardsControlPanelRequestsStatusAccepted' => 'Aceptado',

    'ougcAwardsControlPanelPresetsTitle' => 'Ajustes Preestablecidos de Premio',
    'ougcAwardsControlPanelPresetsTableTitle' => 'Ajustes Preestablecidos de Premio',
    'ougcAwardsControlPanelPresetsTableDescription' => 'Utilice el formulario a continuación para gestionar sus ajustes preestablecidos de premio.',
    'ougcAwardsControlPanelPresetsButtonSelect' => 'Seleccionar Ajuste Preestablecido',
    'ougcAwardsControlPanelPresetsButtonDelete' => 'Eliminar Ajuste Preestablecido',
    'ougcAwardsControlPanelPresetsButtonSetDefault' => 'Establecer como Predeterminado',
    'ougcAwardsControlPanelPresetsButtonCreate' => 'Crear Ajuste Preestablecido',
    'ougcAwardsControlPanelPresetsTableHidden' => 'Oculto',
    'ougcAwardsControlPanelPresetsTableVisible' => 'Visible',
    'ougcAwardsControlPanelPresetsSuccess' => 'El ajuste preestablecido ha sido actualizado.',
    'ougcAwardsControlPanelPresetsError' => 'Hubo un error al actualizar el ajuste preestablecido.',

    'ougcAwardsRequestTitle' => 'Solicitar Premio',
    'ougcAwardsRequestDescription' => 'Envía una solicitud para este premio a un moderador.',
    'ougcAwardsRequestErrorNoPermission' => 'No tienes permiso para ver esta página.',
    'ougcAwardsRequestMessage' => 'Comentario de solicitud',
    'ougcAwardsRequestButtonSend' => 'Enviar Solicitud',

    'ougcAwardsControlPanelTasksTitle' => 'Tareas de Premio',
    'ougcAwardsControlPanelTasksTableTitle' => 'Tareas de Premio',
    'ougcAwardsControlPanelTasksTableEmpty' => 'Actualmente no hay tareas para mostrar.',
    'ougcAwardsControlPanelTasksTableName' => 'Nombre',
    'ougcAwardsControlPanelTasksTableDescription' => 'Descripción',
    'ougcAwardsControlPanelTasksTableRequirements' => 'Requisitos',
    'ougcAwardsControlPanelTasksTableGrant' => 'Conceder',
    'ougcAwardsControlPanelTasksTableRevoke' => 'Revocar',
    'ougcAwardsControlPanelTasksTableEnabled' => 'Habilitado',
    'ougcAwardsControlPanelTasksTableOptions' => 'Opciones',
    'ougcAwardsControlPanelTasksTableOptionsViewLogs' => 'Ver Registros',
    'ougcAwardsControlPanelTasksTableOptionsEdit' => 'Editar Tarea',
    'ougcAwardsControlPanelTasksTableOptionsDelete' => 'Eliminar Tarea',

    'ougcAwardsControlPanelLogsTitle' => 'Registros de Premio',
    'ougcAwardsControlPanelLogsTableTitle' => 'Registros de Premio',
    'ougcAwardsControlPanelLogsTableUser' => 'Usuario',
    'ougcAwardsControlPanelLogsTableGranted' => 'Concedido',
    'ougcAwardsControlPanelLogsTableRevoked' => 'Revocado',
    'ougcAwardsControlPanelLogsTableDate' => 'Fecha',
    'ougcAwardsControlPanelLogsTableOptions' => 'Opciones',
    'ougcAwardsControlPanelLogsTableOptionsDeleteLog' => 'Eliminar Registro',
    'ougcAwardsControlPanelLogsTableEmpty' => 'Actualmente no hay registros para mostrar.',
    'ougcAwardsControlPanelLogsDeleteLogsButton' => 'Eliminar Registros',

    'ougcAwardsControlPanelButtonManageTasks' => 'Ver Tareas',
    'ougcAwardsControlPanelButtonNewTask' => 'Nueva Tarea',
    'ougcAwardsControlPanelButtonManageMyAwards' => 'Mis Premios',
    'ougcAwardsControlPanelButtonManagePresets' => 'Gestionar Ajustes Preestablecidos',

    'ougcAwardsControlPanelViewTasksTypeGroups' => 'Grupos: {1}.',
    'ougcAwardsControlPanelViewTasksTypeThreads' => 'Hilos: {1}{2} hilos.',
    'ougcAwardsControlPanelViewTasksTypePosts' => 'Publicaciones: {1}{2} publicaciones.',
    'ougcAwardsControlPanelViewTasksTypeThreadsForums' => 'Hilos del Foro: {1} {2} hilos en los siguientes foros: {3}.',
    'ougcAwardsControlPanelViewTasksTypePostsForums' => 'Publicaciones del Foro: {1} {2} publicaciones en los siguientes foros: {3}.',
    'ougcAwardsControlPanelViewTasksTypeRegistration' => 'Unido: registrado por al menos {1} {2}.',
    'ougcAwardsControlPanelViewTasksTypeOnline' => 'Tiempo en Línea: pasar al menos {1} {2} en línea.',
    'ougcAwardsControlPanelViewTasksTypeReputation' => 'Reputación: {1}{2} puntos de reputación.',
    'ougcAwardsControlPanelViewTasksTypeReferrals' => 'Referencias: {1}{2} miembros referidos.',
    'ougcAwardsControlPanelViewTasksTypeWarnings' => 'Advertencias: {1}{2} puntos de advertencia.',
    'ougcAwardsControlPanelViewTasksTypeAwardsGranted' => 'Premios Concedidos: debe tener los siguientes premios: {1}',
    'ougcAwardsControlPanelViewTasksTypeProfileFields' => 'Campos de Perfil Llenos: los siguientes campos de perfil deben estar llenos: {1}',
    //'ougcAwardsControlPanelViewTasksTypeNewPoints' => 'Puntos: {1}{2} puntos.',

    'ougcAwardsControlPanelViewTasksTypeGreaterThan' => 'más de ',
    'ougcAwardsControlPanelViewTasksTypeGreaterThanOrEqualTo' => 'al menos ',
    'ougcAwardsControlPanelViewTasksTypeEqualTo' => '',
    'ougcAwardsControlPanelViewTasksTypeLessThanOrEqualTo' => 'no más de ',
    'ougcAwardsControlPanelViewTasksTypeLessThan' => 'menos de ',

    'ougcAwardsControlPanelViewTasksTimeTypeHours' => 'hora',
    'ougcAwardsControlPanelViewTasksTimeTypeHoursPlural' => 'horas',
    'ougcAwardsControlPanelViewTasksTimeTypeDays' => 'día',
    'ougcAwardsControlPanelViewTasksTimeTypeDaysPlural' => 'días',
    'ougcAwardsControlPanelViewTasksTimeTypeWeeks' => 'semana',
    'ougcAwardsControlPanelViewTasksTimeTypeWeeksPlural' => 'semanas',
    'ougcAwardsControlPanelViewTasksTimeTypeMonths' => 'mes',
    'ougcAwardsControlPanelViewTasksTimeTypeMonthsPlural' => 'meses',
    'ougcAwardsControlPanelViewTasksTimeTypeYears' => 'año',
    'ougcAwardsControlPanelViewTasksTimeTypeYearsPlural' => 'años',

    'ougcAwardsControlPanelNewTaskTitle' => 'Nueva Tarea',
    'ougcAwardsControlPanelNewTaskTableTitle' => 'Nueva Tarea',
    'ougcAwardsControlPanelNewTaskTableDescription' => 'Utilice el formulario a continuación para crear una nueva tarea de premio.',
    'ougcAwardsControlPanelNewTaskName' => 'Nombre',
    'ougcAwardsControlPanelNewTaskNameDescription' => 'Seleccione un nombre corto para esta tarea',
    'ougcAwardsControlPanelNewTaskDescription' => 'Descripción',
    'ougcAwardsControlPanelNewTaskDescriptionDescription' => 'Seleccione una descripción corta para esta tarea.',
    'ougcAwardsControlPanelNewTaskEnabled' => 'Habilitado',
    'ougcAwardsControlPanelNewTaskEnabledDescription' => 'Habilitar esta tarea.',
    'ougcAwardsControlPanelNewTaskType' => 'Tipo',
    'ougcAwardsControlPanelNewTaskTypeGrant' => 'Conceder',
    'ougcAwardsControlPanelNewTaskTypeRevoke' => 'Revocar',
    'ougcAwardsControlPanelNewTaskTypeDescription' => 'Seleccione si este es un tipo de tarea de concesión o revocación.',
    'ougcAwardsControlPanelNewTaskRequirements' => 'Requisitos de Criterios',
    'ougcAwardsControlPanelNewTaskRequirementsDescription' => 'Seleccione las reglas para ejecutar esta tarea en los usuarios.',
    'ougcAwardsControlPanelNewTaskRequirementsGroups' => 'Grupos de Usuarios',
    'ougcAwardsControlPanelNewTaskRequirementsGroupsDescription' => 'Seleccione en qué grupo de usuarios o grupos de usuarios debe estar el usuario para que la tarea se ejecute.',
    'ougcAwardsControlPanelNewTaskRequirementsAdditionalGroups' => 'Grupos de Usuarios Secundarios',
    'ougcAwardsControlPanelNewTaskRequirementsAdditionalGroupsDescription' => 'Seleccione si la tarea también debe verificar grupos de usuarios adicionales.',
    'ougcAwardsControlPanelNewTaskRequirementsPostCount' => 'Conteo de Publicaciones',
    'ougcAwardsControlPanelNewTaskRequirementsPostCountDescription' => 'Ingrese el número de publicaciones requeridas. El conteo de publicaciones debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para las publicaciones.',
    'ougcAwardsControlPanelNewTaskRequirementsThreadCount' => 'Conteo de Hilos',
    'ougcAwardsControlPanelNewTaskRequirementsThreadCountDescription' => 'Ingrese el número de hilos requeridos. El conteo de hilos debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para los hilos.',
    'ougcAwardsControlPanelNewTaskRequirementsForumPostCount' => 'Conteo de Publicaciones en el Foro',
    'ougcAwardsControlPanelNewTaskRequirementsForumPostCountDescription' => 'Ingrese el número de publicaciones requeridas en el foro seleccionado. El conteo de publicaciones en el foro debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para las publicaciones.',
    'ougcAwardsControlPanelNewTaskRequirementsForumThreadCount' => 'Conteo de Hilos en el Foro',
    'ougcAwardsControlPanelNewTaskRequirementsForumThreadCountDescription' => 'Ingrese el número de hilos requeridos en el foro seleccionado. El conteo de hilos en el foro debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para los hilos.',
    'ougcAwardsControlPanelNewTaskRequirementsTimeRegistered' => 'Tiempo Registrado',
    'ougcAwardsControlPanelNewTaskRequirementsTimeRegisteredDescription' => 'Ingrese el número de horas, días, semanas, meses o años que este usuario debe haber estado registrado. El tiempo registrado debe seleccionarse como un valor requerido para que esto se incluya. Seleccione si el tiempo registrado debe contarse en horas, días, semanas, meses o años.',
    'ougcAwardsControlPanelNewTaskRequirementsTimeOnline' => 'Tiempo en Línea',
    'ougcAwardsControlPanelNewTaskRequirementsTimeOnlineDescription' => 'Ingrese el número de horas, días, semanas, meses o años que este usuario debe haber estado en línea. El tiempo en línea debe seleccionarse como un valor requerido para que esto se incluya. Seleccione si el tiempo en línea debe contarse en horas, días, semanas, meses o años.',
    'ougcAwardsControlPanelNewTaskRequirementsReputation' => 'Conteo de Reputación',
    'ougcAwardsControlPanelNewTaskRequirementsReputationDescription' => 'Ingrese la cantidad de reputación requerida. La reputación debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para la reputación.',
    'ougcAwardsControlPanelNewTaskRequirementsReferrals' => 'Conteo de Referencias',
    'ougcAwardsControlPanelNewTaskRequirementsReferralsDescription' => 'Ingrese el número de referencias requeridas. El conteo de referencias debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para las referencias.',
    'ougcAwardsControlPanelNewTaskRequirementsWarningPoints' => 'Puntos de Advertencia',
    'ougcAwardsControlPanelNewTaskRequirementsWarningPointsDescription' => 'Ingrese el número de puntos de advertencia requeridos. Los puntos de advertencia deben seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para los puntos de advertencia.',
    'ougcAwardsControlPanelNewTaskRequirementsPreviousAwards' => 'Premios Anteriores',
    'ougcAwardsControlPanelNewTaskRequirementsPreviousAwardsDescription' => 'Ingrese los premios requeridos. Los premios anteriores deben seleccionarse como un valor requerido para que esto se incluya.',
    'ougcAwardsControlPanelNewTaskRequirementsFilledProfileFields' => 'Campos de Perfil Llenos',
    'ougcAwardsControlPanelNewTaskRequirementsFilledProfileFieldsDescription' => 'Ingrese los campos de perfil llenos requeridos. Los campos de perfil llenos deben seleccionarse como un valor requerido para que esto se incluya.',
//'ougcAwardsControlPanelNewTaskRequirementsMyArcadeChampions' => 'Conteo de Archivos de MyDownloads',
//'ougcAwardsControlPanelNewTaskRequirementsMyArcadeChampionsDescription' => 'Ingrese el número de archivos de MyDownloads requeridos. El conteo de archivos de MyDownloads debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para los archivos de MyDownloads.',
//'ougcAwardsControlPanelNewTaskRequirementsMyArcadeScores' => 'Conteo de Puntuaciones de MyArcade',
//'ougcAwardsControlPanelNewTaskRequirementsMyArcadeScoresDescription' => 'Ingrese el número de puntuaciones de MyArcade requeridas. El conteo de puntuaciones de MyArcade debe seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para la puntuación de MyArcade.',
    'ougcAwardsControlPanelNewTaskRequirementsCustomReputationReceived' => 'Reputación Personalizada Recibida',
    'ougcAwardsControlPanelNewTaskRequirementsCustomReputationGiven' => 'Reputación Personalizada Dada',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScripts' => 'Campo Personalizado: Script JSON',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScriptsDescription' => 'Script compatible con JSON para establecer verificaciones de promoción complejas. <a href="https://github.com/OUGC-Network/OUGC-Awards" target="_blank">Lea la documentación</a> para más información sobre esto.',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScriptsDescriptionPlaceHolder' => '{
	"whereClauses":[
		{
			"tableName":"threads",
			"columnName":"tid",
			"columnValue":3,
			"columnOperator":">=",
			"aggregateFunction":"COUNT",
			"aggregateAlias":"totalThreads"
		},
		{
			"tableName":"threads",
			"columnName":"visible",
			"columnValue":1,
			"columnOperator":"="
		},
		{
			"tableName":"forums",
			"columnName":"fid",
			"columnValue":[
				2,
				30
			],
			"columnOperator":"IN",
			"relationMainField":"ougcCustomPromotionFieldTable_threads.fid",
			"relationSecondaryField":"fid"
		}
	],
	"logicalOperator":"AND"
}',
    //'ougcAwardsControlPanelNewTaskRequirementsNewpoints' => 'Puntos de Newpoints',
//'ougcAwardsControlPanelNewTaskRequirementsNewpointsDescription' => 'Ingrese el número de puntos de Newpoints requeridos. Los puntos de Newpoints deben seleccionarse como un valor requerido para que esto se incluya. Seleccione el tipo de comparación para los puntos de Newpoints.',

    'ougcAwardsControlPanelDeleteTaskTableTitle' => 'Eliminar Tarea',
    'ougcAwardsControlPanelDeleteTaskTableButton' => 'Eliminar Tarea',
    'ougcAwardsControlPanelDeleteTaskTableDescription' => '¿Está seguro de que desea eliminar la tarea seleccionada?',

    'ougcAwardsControlPanelGreaterThan' => 'Mayor que',
    'ougcAwardsControlPanelGreaterThanOrEqualTo' => 'Mayor o igual que',
    'ougcAwardsControlPanelEqualTo' => 'Igual a',
    'ougcAwardsControlPanelLessThanOrEqualTo' => 'Menor o igual que',
    'ougcAwardsControlPanelLessThan' => 'Menor que',

    'ougcAwardsControlPanelHours' => 'Horas',
    'ougcAwardsControlPanelDays' => 'Días',
    'ougcAwardsControlPanelWeeks' => 'Semanas',
    'ougcAwardsControlPanelMonths' => 'Meses',
    'ougcAwardsControlPanelYears' => 'Años',

    'ougcAwardsControlPanelNewTaskGrant' => 'Conceder Premio',
    'ougcAwardsControlPanelNewTaskGrantDescription' => 'Seleccione el(los) premio(s) a conceder a los usuarios.',
    'ougcAwardsControlPanelNewTaskReason' => 'Razón de la Concesión',
    'ougcAwardsControlPanelNewTaskReasonDescription' => 'Seleccione una razón para conceder este premio.',
    'ougcAwardsControlPanelNewTaskThread' => 'Hilo de Concesión',
    'ougcAwardsControlPanelNewTaskThreadDescription' => 'Por favor, introduzca un hilo para asignar a las concesiones de premios.',
    'ougcAwardsControlPanelNewTaskMultiple' => 'Permitir Múltiples Premios',
    'ougcAwardsControlPanelNewTaskMultipleDescription' => 'Seleccione si esta tarea debe conceder premios a usuarios que ya lo tienen.',
    'ougcAwardsControlPanelNewTaskRevoke' => 'Revocar Premio',
    'ougcAwardsControlPanelNewTaskRevokeDescription' => 'Seleccione el(los) premio(s) a revocar de los usuarios.',
    'ougcAwardsControlPanelNewTaskDisplayOrder' => 'Orden de Visualización',
    'ougcAwardsControlPanelNewTaskDisplayOrderDescription' => 'Seleccione el orden de visualización para esta tarea.',
    'ougcAwardsControlPanelNewTaskButton' => 'Crear Tarea',

    'ougcAwardsControlPanelEditTaskTitle' => 'Editar Tareas',
    'ougcAwardsControlPanelEditTaskTableTitle' => 'Editar Tarea',
    'ougcAwardsControlPanelEditTaskTableDescription' => 'Utilice el formulario a continuación para actualizar una tarea de premio.',
    'ougcAwardsControlPanelEditTaskButton' => 'Actualizar Tarea',

    'ougcAwardsErrorInvalidCategory' => 'La categoría seleccionada no es válida.',
    'ougcAwardsErrorInvalidAward' => 'El premio seleccionado no existe.',
    'ougcAwardsErrorInvalidTask' => 'La tarea seleccionada no existe.',
    'ougcAwardsErrorInvalidOwner' => 'El propietario del premio seleccionado no existe.',
    'ougcAwardsErrorInvalidUsers' => 'Algunos de los usuarios seleccionados no existen.',
    'ougcAwardsErrorDuplicatedCategoryOwner' => 'Algunos de los usuarios seleccionados ya están asignados como propietarios de esta categoría.',
    'ougcAwardsErrorDuplicatedOwner' => 'Algunos de los usuarios seleccionados ya están asignados como propietarios de este premio.',
    'ougcAwardsErrorPendingRequest' => 'Ya tienes una solicitud abierta para este premio.',
    'ougcAwardsErrorInvalidGrant' => 'La concesión de premio seleccionada no existe.',
    'ougcAwardsErrorInvalidGrantReason' => 'La razón de concesión seleccionada no es válida.',
    'ougcAwardsErrorInvalidGrantDate' => 'La fecha de concesión seleccionada no es válida.',
    'ougcAwardsErrorInvalidThread' => 'El hilo seleccionado no existe.',
    'ougcAwardsErrorInvalidCategoryName' => 'El nombre de la categoría seleccionada no es válido.',
    'ougcAwardsErrorInvalidCategoryDescription' => 'La descripción de la categoría seleccionada no es válida.',
    'ougcAwardsErrorInvalidAwardName' => 'El nombre del premio seleccionado no es válido.',
    'ougcAwardsErrorInvalidAwardDescription' => 'La descripción del premio seleccionada no es válida.',
    'ougcAwardsErrorInvalidAwardImage' => 'La imagen del premio seleccionada no es válida.',

    'ougcAwardsErrorInvalidTaskName' => 'El nombre de la tarea seleccionada no es válido.',
    'ougcAwardsErrorInvalidTaskDescription' => 'La descripción de la tarea seleccionada no es válida.',
    'ougcAwardsErrorInvalidTaskScript' => 'El script JSON seleccionado no es válido.',

    'ougcAwardsErrorNoUsersPermission' => 'No tienes permiso para editar el usuario seleccionado.',

    'ougcAwardsRedirectMyAwardsUpdated' => 'Tus premios se actualizaron correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectCategoryCreated' => 'La categoría se creó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectCategoryUpdated' => 'La categoría se actualizó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectCategoryDeleted' => 'La categoría se eliminó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectAwardCreated' => 'El premio se creó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectAwardUpdated' => 'El premio se actualizó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectAwardDeleted' => 'El premio se eliminó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectCategoryOwnerAssigned' => 'El propietario de la categoría se asignó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectOwnerAssigned' => 'El propietario del premio se asignó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectCategoryOwnerRevoked' => 'El propietario de la categoría se revocó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectOwnerRevoked' => 'El propietario del premio se revocó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectGranted' => 'El premio se concedió correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectGrantedUpdated' => 'La concesión del premio se actualizó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectGrantRevokedMultiple' => 'Los otorgamientos del premio seleccionados han sido revocados correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectGrantRevoked' => 'La concesión del premio se revocó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectPresetCreated' => 'El ajuste preestablecido del premio se creó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectPresetUpdated' => 'El ajuste preestablecido del premio se actualizó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectPresetDeleted' => 'El ajuste preestablecido del premio se eliminó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectLogDeleted' => 'El registro de la tarea se eliminó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectLogsDeleted' => 'Los registros seleccionados de la tarea se eliminaron correctamente.<br />Ahora serás redirigido de vuelta.',

    'ougcAwardsRedirectRequest' => 'La solicitud de premio se envió correctamente.',

    'ougcAwardsRedirectTaskCreated' => 'La tarea se creó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectTaskUpdated' => 'La tarea se actualizó correctamente.<br />Ahora serás redirigido de vuelta.',
    'ougcAwardsRedirectTaskDeleted' => 'La tarea se eliminó correctamente.<br />Ahora serás redirigido de vuelta.',

    'ougcAwardsPrivateMessageTitle' => '¡Se te ha concedido el premio {1}!',
    'ougcAwardsPrivateMessageRequestRejectedTitle' => 'Tu solicitud para el premio {1} fue rechazada.',
    'ougcAwardsPrivateMessageRequestRejectedBody' => 'Hola {1}. Este es un mensaje automático para informarte que tu solicitud para el premio {2} fue rechazada.

Saludos.',

    'ougcAwardsTaskRan' => 'La tarea de premios se ejecutó con éxito.',

    'ougcAwardsPostTitle' => 'Premios de {1}',
    'ougcAwardsPostTitleSection' => 'Premios de {1} en {2}',
    'ougcAwardsPostViewAll' => 'Ver Todo',
    'ougcAwardsPostPresetsTitle' => 'Premios',
    'ougcAwardsProfilePresetsTitle' => 'Premios',
    'ougcAwardsWhoIsOnlineViewing' => 'Viendo <a href="{1}/awards.php">Página de Premios</a>',

    'ougcAwardsStatsMostTitle' => 'Usuarios Más Otorgados',
    'ougc_awards_stats_last' => 'Últimos Otorgados',
    'ougc_awards_stats_empty' => 'Actualmente no hay estadísticas para mostrar.',
    'ougcAwardsStatsUser' => 'Usuario',
    'ougcAwardsStatsTotal' => 'Total',

    'ougcAwardsGlobalNotificationRequests' => '<strong>Solicitud de Premio:</strong> <a href="{1}/{2}">Hay una solicitud de premio pendiente de revisión.</a>',
    'ougcAwardsGlobalNotificationRequestsPlural' => '<strong>Solicitud de Premio:</strong> <a href="{1}/{2}">Hay {3} solicitudes de premio pendientes de revisión.</a>',

    'ougcAwardsProfileViewAll' => 'Ver Todo',
    'ougcAwardsProfileTitle' => 'Premios de {1}',
    'ougcAwardsProfileTitleSection' => 'Premios de {1} en {2}',
    'ougcAwardsProfileEmpty' => 'Actualmente no hay premios para mostrar.',
    'ougcAwardsViewUser' => 'Ver Premios del Usuario',
    'ougcAwardsViewUserTitle' => 'Premios de {1}',
    'ougcAwardsViewUserEmpty' => 'Actualmente no hay premios para mostrar.',
    'ougcAwardsMyAlerts' => '{2} te ha otorgado el premio {3}.',

    'ougcAwardsGlobalAllCategories' => 'Cualquier Categoria',

    // {4} outputs the award formatted image
    'myalerts_setting_ougc_awards' => '¿Recibir alerta cuando se otorga un premio o se rechaza una solicitud de premio?',

    'ougcAwardsDvzStream' => 'Premios Otorgados',
    'ougcAwardsDvzStreamEvent' => 'Premio Otorgado',
    'ougcAwardsDvzStreamTextUser' => 'Se le otorgó el premio "{1}".',

];