<?php

/***************************************************************************
 *
 *    ougc Awards plugin (/inc/languages/english/ougc_awards.lang.php)
 *    Author: Omar Gonzalez
 *    Copyright: © 2012-2020 Omar Gonzalez
 *
 *    Website: https://ougc.network
 *
 *    Manage a powerful awards system for your community.
 *
 ***************************************************************************
 ****************************************************************************
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/

$l = [
    'ougcAwards' => 'Awards',

    'ougcAwardsPageNavigation' => 'Awards',
    'ougcAwardsNoReason' => 'No reason specified.',
    'ougcAwardsGlobalMenu' => 'Awards',
    'ougcAwardsWelcomeLinkText' => 'View My Awards',
    'ougcAwardsWelcomeLinkTextSection' => 'View My Awards in {1}',

    'ougcAwardsButtonRequest' => 'Request',

    'ougcAwardsGlobalNotificationsRequests' => 'There are {1} award requests waiting for approval.',

    'ougcAwardsRedirectRequestAccepted' => 'Award request accepted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectRequestRejected' => 'Award request rejected successfully.<br />You will now be redirected back.',

    'ougcAwardsControlPanelRequestsButtonAccept' => 'Accept',
    'ougcAwardsControlPanelRequestsButtonReject' => 'Reject',

    'ougcAwardsControlPanelRequestsFilterTitle' => 'Filter',
    'ougcAwardsControlPanelRequestsFilterStatus' => 'Status',
    'ougcAwardsControlPanelRequestsFilterStatusOpen' => 'Open',
    'ougcAwardsControlPanelRequestsFilterStatusAccepted' => 'Accepted',
    'ougcAwardsControlPanelRequestsFilterStatusRejected' => 'Rejected',

    'ougcAwardsErrorRequestsNoneSelected' => 'No awards were selected.',
    'ougcAwardsErrorUploadFailed' => 'The award image upload failed.',
    'ougcAwardsErrorUploadInvalidType' => 'The award image type is invalid.',
    'ougcAwardsErrorUploadReize' => 'The award image resize failed.',
    'ougcAwardsErrorUploadSize' => 'The award image size is invalid.',

    'ougcAwardsControlPanelNavigation' => 'Awards',
    'ougcAwardsControlPanelButtonNewCategory' => 'New Category',

    'ougcAwardsControlPanelNewCategoryTitle' => 'New Category',
    'ougcAwardsControlPanelNewCategoryTableTitle' => 'New Category',
    'ougcAwardsControlPanelNewCategoryTableDescription' => 'Use the form below to create a new category.',
    'ougcAwardsControlPanelNewCategoryName' => 'Name',
    'ougcAwardsControlPanelNewCategoryNameDescription' => 'Select a short name for this category.',
    'ougcAwardsControlPanelNewCategoryDescription' => 'Description',
    'ougcAwardsControlPanelNewCategoryDescriptionDescription' => 'Select a short description for this category.',
    'ougcAwardsControlPanelNewCategoryAllowRequests' => 'Allow User Requests',
    'ougcAwardsControlPanelNewCategoryAllowRequestsDescription' => 'Allow users to request this category.',
    'ougcAwardsControlPanelNewCategoryEnabled' => 'Enabled',
    'ougcAwardsControlPanelNewCategoryEnabledDescription' => 'Enable this category.',
    'ougcAwardsControlPanelNewCategoryDisplayOrder' => 'Display Order',
    'ougcAwardsControlPanelNewCategoryDisplayOrderDescription' => 'Select the display order for this category.',
    'ougcAwardsControlPanelNewCategoryOutputInCustomSection' => 'Output in Custom Section',
    'ougcAwardsControlPanelNewCategoryOutputInCustomSectionDescription' => 'Enable this to display awards from this category in its custom section.',
    'ougcAwardsControlPanelNewCategoryHideInMainPage' => 'Hide in Main Page',
    'ougcAwardsControlPanelNewCategoryHideInMainPageDescription' => 'Enable this to hide in Main Page if the user is not a moderator nor a category owner.',
    'ougcAwardsControlPanelNewCategoryButton' => 'Create Category',

    'ougcAwardsControlPanelEditCategoryTitle' => 'Edit Category',
    'ougcAwardsControlPanelEditCategoryTableTitle' => 'Edit Category',
    'ougcAwardsControlPanelEditCategoryTableDescription' => 'Use the form below to update the selected category.',
    'ougcAwardsControlPanelEditCategoryButton' => 'Update Category',

    'ougcAwardsControlPanelTitle' => 'Awards',
    'ougcAwardsControlPanelAward' => 'Award',
    'ougcAwardsControlPanelName' => 'Name',
    'ougcAwardsControlPanelDescription' => 'Description',
    'ougcAwardsControlPanelEmpty' => 'There are currently no awards to display.',
    'ougcAwardsControlPanelAwardViewOwners' => 'View Owners',
    'ougcAwardsControlPanelAwardNewAward' => 'New Award',
    'ougcAwardsControlPanelAwardEditCategory' => 'Edit',
    'ougcAwardsControlPanelAwardDeleteCategory' => 'Delete',
    'ougcAwardsControlPanelEnabled' => 'Enabled',
    'ougcAwardsControlPanelDisplayOrder' => 'Display Order',
    'ougcAwardsControlPanelOptions' => 'Options',
    'ougcAwardsControlPanelRequest' => 'Request',
    'ougcAwardsControlPanelViewUsers' => 'View Users',
    'ougcAwardsControlPanelViewOwners' => 'View Owners',
    'ougcAwardsControlPanelViewRequests' => 'View Requests',
    'ougcAwardsControlPanelEditAward' => 'Edit Award',
    'ougcAwardsControlPanelDeleteAward' => 'Delete Award',
    'ougcAwardsControlPanelRequestAward' => 'Request Award',
    'ougcAwardsControlPanelButtonUpdate' => 'Update Awards',
    'ougcAwardsControlPanelButtonNewAward' => 'New Award',

    'ougcAwardsControlPanelNewAwardTitle' => 'New Award',
    'ougcAwardsControlPanelNewAwardTableTitle' => 'New Award',
    'ougcAwardsControlPanelNewAwardTableDescription' => 'Use the form below to create a new award.',
    'ougcAwardsControlPanelNewAwardName' => 'Name',
    'ougcAwardsControlPanelNewAwardNameDescription' => 'Select a short name for this award.',
    'ougcAwardsControlPanelNewAwardDescription' => 'Description',
    'ougcAwardsControlPanelNewAwardDescriptionDescription' => 'Select a short description for this award.',
    'ougcAwardsControlPanelNewAwardCategory' => 'Category',
    'ougcAwardsControlPanelNewAwardCategoryDescription' => 'Select the category for this award.',
    'ougcAwardsControlPanelNewAwardImageFile' => 'Icon File',
    'ougcAwardsControlPanelNewAwardImageFileDescription' => 'Upload an image for this award.',
    'ougcAwardsControlPanelNewAwardImageFileNote' => 'Current file icon will be replaced if a new file is uploaded.',
    'ougcAwardsControlPanelNewAwardImageType' => 'URL / Class',
    'ougcAwardsControlPanelNewAwardImageTypeDescription' => 'Enter the image path or class name for this award below. The following variables are available.<br />Leave empty to use the uploaded file icon.<br /><pre style="color: darkgreen;">
{forum_url} -> Forum URL
{images_url} -> Theme images URL
{award_id} -> Award identifier
{category_id} -> Category identifier
</pre>',
    'ougcAwardsControlPanelNewAwardTemplateType' => 'Icon Type',
    'ougcAwardsControlPanelNewAwardTemplateTypeDescription' => 'Select what icon type to use for this award.<br /><pre style="color: darkgreen;">
File or URL Icon: Best for image (file) awards.
Class Icon: Best for CSS (class) awards.
Custom Icon (Advanced): A custom template for this award.
</pre>',
    'ougcAwardsControlPanelNewAwardTemplateTypeImage' => 'File or URL Icon',
    'ougcAwardsControlPanelNewAwardTemplateTypeClass' => 'Class Icon',
    'ougcAwardsControlPanelNewAwardTemplateTypeCustom' => 'Custom Icon (Advanced)',
    'ougcAwardsControlPanelNewAwardAllowRequests' => 'Allow User Requests',
    'ougcAwardsControlPanelNewAwardAllowRequestsDescription' => 'Allow users to request this award.',
    'ougcAwardsControlPanelNewAwardPrivateMessage' => 'Private Message Content',
    'ougcAwardsControlPanelNewAwardPrivateMessageDescription' => 'If not empty, will send a Private Message whenever this award is granted.<br /><pre style="color: darkgreen;">
{user_name} = Username
{award_name} = Award name
{grant_reason} = Reason
{award_icon} = Image
{forum_name} = Forum name
</pre>',
    'ougcAwardsControlPanelNewAwardDisplayType' => 'Display Type',
    'ougcAwardsControlPanelNewAwardDisplayTypeDescription' => 'Select if this award will be displayed in posts, profiles, or both.',
    'ougcAwardsControlPanelNewAwardDisplayTypeBoth' => 'Both',
    'ougcAwardsControlPanelNewAwardDisplayTypeProfile' => 'Profile',
    'ougcAwardsControlPanelNewAwardDisplayTypePosts' => 'Posts',
    'ougcAwardsControlPanelNewAwardButton' => 'Create Award',

    'ougcAwardsControlPanelEditAwardTitle' => 'Edit Award',
    'ougcAwardsControlPanelEditAwardTableTitle' => 'Edit Award',
    'ougcAwardsControlPanelEditAwardTableDescription' => 'Use the form below to update the selected award.',
    'ougcAwardsControlPanelEditAwardButton' => 'Update Award',

    'ougcAwardsControlPanelDeleteAwardTitle' => 'Delete Award',
    'ougcAwardsControlPanelDeleteAwardTableTitle' => 'Delete Award',
    'ougcAwardsControlPanelDeleteAwardTableDescription' => 'Are you sure you want to delete the selected award?',
    'ougcAwardsControlPanelDeleteAwardDetailTotalGranted' => 'Total award grant records',
    'ougcAwardsControlPanelDeleteAwardDetailTotalOwners' => 'Total owner records',
    'ougcAwardsControlPanelDeleteAwardDetailTotalRequests' => 'Total request records',
    'ougcAwardsControlPanelDeleteAwardButton' => 'Delete Award',

    'ougcAwardsControlPanelDeleteCategoryTitle' => 'Delete Category',
    'ougcAwardsControlPanelDeleteCategoryTableTitle' => 'Delete Category',
    'ougcAwardsControlPanelDeleteCategoryTableDescription' => 'Are you sure you want to delete the selected category?',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalAwards' => 'Total award records',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalGranted' => 'Total award grant records',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalCategoryOwners' => 'Total category owner records',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalOwners' => 'Total owner records',
    'ougcAwardsControlPanelDeleteCategoryDetailTotalRequests' => 'Total request records',
    'ougcAwardsControlPanelDeleteCategoryButton' => 'Delete Category',

    'ougcAwardsControlPanelUsersEmpty' => 'There are currently no users to display.',

    'ougcAwardsControlPanelUsersTitle' => 'Granted Users',
    'ougcAwardsControlPanelUsersTableTitle' => 'Granted Users',
    'ougcAwardsControlPanelUsersTableUsername' => 'Username',
    'ougcAwardsControlPanelUsersTableReason' => 'Reason',
    'ougcAwardsControlPanelUsersTableThread' => 'Thread',
    'ougcAwardsControlPanelUsersTableDate' => 'Date',
    'ougcAwardsControlPanelUsersTableOptions' => 'Options',
    'ougcAwardsControlPanelUsersTableOptionsEditGrant' => 'Edit Grant',
    'ougcAwardsControlPanelUsersRevokeButton' => 'Revoke Grants',

    'ougcAwardsControlPanelMyAwardsEmpty' => 'There are currently no awards to display.',

    'ougcAwardsControlPanelMyAwardsTitle' => 'My Awards',
    'ougcAwardsControlPanelMyAwardsTableTitle' => 'My Awards',
    'ougcAwardsControlPanelMyAwardsTableAward' => 'Award',
    'ougcAwardsControlPanelMyAwardsTableName' => 'Name',
    'ougcAwardsControlPanelMyAwardsTableReason' => 'Reason',
    'ougcAwardsControlPanelMyAwardsTableThread' => 'Thread',
    'ougcAwardsControlPanelMyAwardsTableDate' => 'Date',
    'ougcAwardsControlPanelMyAwardsTableDisplay' => 'Display',
    'ougcAwardsControlPanelMyAwardsTableDisplayOrder' => 'Display Order',

    'ougcAwardsControlPanelCategoryOwnersEmpty' => 'There are currently no users to display.',

    'ougcAwardsControlPanelCategoryOwnersTitle' => 'Category Owners',
    'ougcAwardsControlPanelCategoryOwnersTableTitle' => 'Category Owners',

    'ougcAwardsControlPanelCategoryOwnersForm' => 'Assign Owner',
    'ougcAwardsControlPanelCategoryOwnersFormDescription' => 'Use the form below to assign new owners to this category.',
    'ougcAwardsControlPanelCategoryOwnersFormUsernames' => 'Usernames',
    'ougcAwardsControlPanelCategoryOwnersFormButton' => 'Assign Owner',

    'ougcAwardsControlPanelOwnersEmpty' => 'There are currently no users to display.',

    'ougcAwardsControlPanelOwnersTitle' => 'Owners',
    'ougcAwardsControlPanelOwnersTableTitle' => 'Award Owners',
    'ougcAwardsControlPanelOwnersTableUsername' => 'Username',
    'ougcAwardsControlPanelOwnersTableDate' => 'Date',
    'ougcAwardsControlPanelOwnersTableOptions' => 'Options',
    'ougcAwardsControlPanelUsersTableOptionsDelete' => 'Revoke Owner',

    'ougcAwardsControlPanelOwnersForm' => 'Assign Owner',
    'ougcAwardsControlPanelOwnersFormDescription' => 'Use the form below to assign new owners to this award.',
    'ougcAwardsControlPanelOwnersFormUsernames' => 'Usernames',
    'ougcAwardsControlPanelOwnersFormButton' => 'Assign Owner',

    'ougcAwardsControlPanelGrantTable' => 'Grant Award',
    'ougcAwardsControlPanelGrantTableDescription' => 'Grant this award to users.',
    'ougcAwardsControlPanelGrantTableUsernames' => 'Usernames',
    'ougcAwardsControlPanelGrantTableReason' => 'Reason',
    'ougcAwardsControlPanelGrantTableThread' => 'Thread',
    'ougcAwardsControlPanelGrantButton' => 'Grant Award',

    'ougcAwardsControlPanelRevokeTable' => 'Revoke Award',
    'ougcAwardsControlPanelRevokeTableDescription' => 'Revoke this award from users.',
    'ougcAwardsControlPanelRevokeTableUsernames' => 'Usernames',
    'ougcAwardsControlPanelRevokeButton' => 'Revoke Award',

    'ougcAwardsControlPanelEditGrantTitle' => 'Edit Grant',
    'ougcAwardsControlPanelEditGrantTableTitle' => 'Edit Grant',
    'ougcAwardsControlPanelEditGrantTableDescription' => 'Use the form below to edit an existing award grant.',
    'ougcAwardsControlPanelEditGrantTableReason' => 'Grant Reason',
    'ougcAwardsControlPanelEditGrantTableReasonDescription' => 'Select a reason for granting this award.',
    'ougcAwardsControlPanelEditGrantTableThread' => 'Grant Thread',
    'ougcAwardsControlPanelEditGrantTableThreadDescription' => 'Please enter an thread to assign this granting to.',
    'ougcAwardsControlPanelEditGrantTableDate' => 'Grant Date',
    'ougcAwardsControlPanelEditGrantTableDateDescription' => 'Modify the grant time stamp.',
    'ougcAwardsControlPanelEditGrantButton' => 'Update Grant',

    'ougcAwardsControlPanelDeleteCategoryOwnersTitle' => 'Delete Category Owner',
    'ougcAwardsControlPanelDeleteCategoryOwnersDescription' => 'Are you sure you want to delete the selected owner?',
    'ougcAwardsControlPanelDeleteCategoryOwnersButton' => 'Delete Category Owner',

    'ougcAwardsControlPanelDeleteOwnersTitle' => 'Delete Owner',
    'ougcAwardsControlPanelDeleteOwnersDescription' => 'Are you sure you want to delete the selected owner?',
    'ougcAwardsControlPanelDeleteOwnersButton' => 'Delete Owner',

    'ougcAwardsControlPanelRequests' => 'Award Requests',
    'ougcAwardsControlPanelRequestsTableTitle' => 'Award Requests',

    'ougcAwardsControlPanelRequestsEmpty' => 'There are currently no requests to display.',
    'ougcAwardsControlPanelRequestsTableAward' => 'Award',
    'ougcAwardsControlPanelRequestsTableUsername' => 'Username',
    'ougcAwardsControlPanelRequestsTableMessage' => 'Message',
    'ougcAwardsControlPanelRequestsTableStatus' => 'Status',
    'ougcAwardsControlPanelRequestsTableOptions' => 'Options',

    'ougcAwardsControlPanelRequestsStatusPending' => 'Pending',
    'ougcAwardsControlPanelRequestsStatusRejected' => 'Rejected',
    'ougcAwardsControlPanelRequestsStatusAccepted' => 'Accepted',

    'ougcAwardsControlPanelPresetsTitle' => 'Award Presets',
    'ougcAwardsControlPanelPresetsTableTitle' => 'Award Presets',
    'ougcAwardsControlPanelPresetsTableDescription' => 'Use the form below to manage your award presets.',
    'ougcAwardsControlPanelPresetsButtonSelect' => 'Select Preset',
    'ougcAwardsControlPanelPresetsButtonDelete' => 'Delete Preset',
    'ougcAwardsControlPanelPresetsButtonSetDefault' => 'Set Default',
    'ougcAwardsControlPanelPresetsButtonCreate' => 'Create Preset',
    'ougcAwardsControlPanelPresetsTableHidden' => 'Hidden',
    'ougcAwardsControlPanelPresetsTableVisible' => 'Visible',
    'ougcAwardsControlPanelPresetsSuccess' => 'The preset has been updated.',
    'ougcAwardsControlPanelPresetsError' => 'There was an error updating the preset.',

    'ougcAwardsRequestTitle' => 'Request Award',
    'ougcAwardsRequestDescription' => 'Send a request for this award to a moderator.',
    'ougcAwardsRequestErrorNoPermission' => 'You do not have permission to view this page.',
    'ougcAwardsRequestMessage' => 'Request comment',
    'ougcAwardsRequestButtonSend' => 'Send Request',

    'ougcAwardsControlPanelTasksTitle' => 'Award Tasks',
    'ougcAwardsControlPanelTasksTableTitle' => 'Award Tasks',
    'ougcAwardsControlPanelTasksTableEmpty' => 'There are currently no tasks to display.',
    'ougcAwardsControlPanelTasksTableName' => 'Name',
    'ougcAwardsControlPanelTasksTableDescription' => 'Description',
    'ougcAwardsControlPanelTasksTableRequirements' => 'Requirements',
    'ougcAwardsControlPanelTasksTableGrant' => 'Grant',
    'ougcAwardsControlPanelTasksTableRevoke' => 'Revoke',
    'ougcAwardsControlPanelTasksTableEnabled' => 'Enabled',
    'ougcAwardsControlPanelTasksTableOptions' => 'Options',
    'ougcAwardsControlPanelTasksTableOptionsViewLogs' => 'View Logs',
    'ougcAwardsControlPanelTasksTableOptionsEdit' => 'Edit Task',
    'ougcAwardsControlPanelTasksTableOptionsDelete' => 'Delete Task',

    'ougcAwardsControlPanelLogsTitle' => 'Award Logs',
    'ougcAwardsControlPanelLogsTableTitle' => 'Award Logs',
    'ougcAwardsControlPanelLogsTableUser' => 'User',
    'ougcAwardsControlPanelLogsTableGranted' => 'Granted',
    'ougcAwardsControlPanelLogsTableRevoked' => 'Revoked',
    'ougcAwardsControlPanelLogsTableDate' => 'Date',
    'ougcAwardsControlPanelLogsTableOptions' => 'Options',
    'ougcAwardsControlPanelLogsTableOptionsDeleteLog' => 'Delete Log',
    'ougcAwardsControlPanelLogsTableEmpty' => 'There are currently no logs for this task.',
    'ougcAwardsControlPanelLogsDeleteLogsButton' => 'Delete Logs',

    'ougcAwardsControlPanelButtonManageTasks' => 'View Tasks',
    'ougcAwardsControlPanelButtonNewTask' => 'New Task',
    'ougcAwardsControlPanelButtonManageMyAwards' => 'My Awards',
    'ougcAwardsControlPanelButtonManagePresets' => 'Manage Presets',

    'ougcAwardsControlPanelViewTasksTypeGroups' => 'Groups: {1}.',
    'ougcAwardsControlPanelViewTasksTypeThreads' => 'Threads: {1}{2} threads.',
    'ougcAwardsControlPanelViewTasksTypePosts' => 'Posts: {1}{2} posts.',
    'ougcAwardsControlPanelViewTasksTypeThreadsForums' => 'Forum Threads: {1} {2} threads in the following forums: {3}.',
    'ougcAwardsControlPanelViewTasksTypePostsForums' => 'Forum Posts: {1} {2} posts in the following forums: {3}.',
    'ougcAwardsControlPanelViewTasksTypeRegistration' => 'Joined: registered for at least {1} {2}.',
    'ougcAwardsControlPanelViewTasksTypeOnline' => 'Time Online: spend at least {1} {2} online.',
    'ougcAwardsControlPanelViewTasksTypeReputation' => 'Reputation: {1}{2} reputation points.',
    'ougcAwardsControlPanelViewTasksTypeReferrals' => 'Referrals: {1}{2} members referred.',
    'ougcAwardsControlPanelViewTasksTypeWarnings' => 'Warnings: {1}{2} warning points.',
    'ougcAwardsControlPanelViewTasksTypeAwardsGranted' => 'Awards Granted: must have the following awards: {1}',
    'ougcAwardsControlPanelViewTasksTypeProfileFields' => 'Filled Profile Fields: the following profile fields must be filled: {1}',
    //'ougcAwardsControlPanelViewTasksTypeNewPoints' => 'Points: {1}{2} points.',

    'ougcAwardsControlPanelViewTasksTypeGreaterThan' => 'more than ',
    'ougcAwardsControlPanelViewTasksTypeGreaterThanOrEqualTo' => 'at least ',
    'ougcAwardsControlPanelViewTasksTypeEqualTo' => 'exactly ',
    'ougcAwardsControlPanelViewTasksTypeNotEqualTo' => 'not ',
    'ougcAwardsControlPanelViewTasksTypeLessThanOrEqualTo' => 'at most',
    'ougcAwardsControlPanelViewTasksTypeLessThan' => 'less than ',

    'ougcAwardsControlPanelViewTasksTimeTypeHours' => 'hour',
    'ougcAwardsControlPanelViewTasksTimeTypeHoursPlural' => 'hours',
    'ougcAwardsControlPanelViewTasksTimeTypeDays' => 'day',
    'ougcAwardsControlPanelViewTasksTimeTypeDaysPlural' => 'days',
    'ougcAwardsControlPanelViewTasksTimeTypeWeeks' => 'week',
    'ougcAwardsControlPanelViewTasksTimeTypeWeeksPlural' => 'weeks',
    'ougcAwardsControlPanelViewTasksTimeTypeMonths' => 'month',
    'ougcAwardsControlPanelViewTasksTimeTypeMonthsPlural' => 'months',
    'ougcAwardsControlPanelViewTasksTimeTypeYears' => 'year',
    'ougcAwardsControlPanelViewTasksTimeTypeYearsPlural' => 'years',

    'ougcAwardsControlPanelNewTaskTitle' => 'New Task',
    'ougcAwardsControlPanelNewTaskTableTitle' => 'New Task',
    'ougcAwardsControlPanelNewTaskTableDescription' => 'Use the form below to create a new award task.',
    'ougcAwardsControlPanelNewTaskName' => 'Name',
    'ougcAwardsControlPanelNewTaskNameDescription' => 'Select a short name for this task',
    'ougcAwardsControlPanelNewTaskDescription' => 'Description',
    'ougcAwardsControlPanelNewTaskDescriptionDescription' => 'Select a short description for this task. You may use MyCode in the description.',
    'ougcAwardsControlPanelNewTaskEnabled' => 'Enabled',
    'ougcAwardsControlPanelNewTaskEnabledDescription' => 'Enable this task.',
    'ougcAwardsControlPanelNewTaskType' => 'Type',
    'ougcAwardsControlPanelNewTaskTypeGrant' => 'Grant',
    'ougcAwardsControlPanelNewTaskTypeRevoke' => 'Revoke',
    'ougcAwardsControlPanelNewTaskTypeDescription' => 'Select if this is a grant or revoke task type.',
    'ougcAwardsControlPanelNewTaskRequirements' => 'Criteria Requirements',
    'ougcAwardsControlPanelNewTaskRequirementsDescription' => 'Select the rules to execute this task on users.',
    'ougcAwardsControlPanelNewTaskRequirementsGroups' => 'User Groups',
    'ougcAwardsControlPanelNewTaskRequirementsGroupsDescription' => 'Select which user group or user groups the user must be in for the task to run.',
    'ougcAwardsControlPanelNewTaskRequirementsAdditionalGroups' => 'Secondary User Groups',
    'ougcAwardsControlPanelNewTaskRequirementsAdditionalGroupsDescription' => 'Select whether the task should check for additional user groups as well.',
    'ougcAwardsControlPanelNewTaskRequirementsPostCount' => 'Post Count',
    'ougcAwardsControlPanelNewTaskRequirementsPostCountDescription' => 'Enter the number of posts required. Post count must be selected as a required value for this to be included. Select the type of comparison for posts.',
    'ougcAwardsControlPanelNewTaskRequirementsThreadCount' => 'Thread Count',
    'ougcAwardsControlPanelNewTaskRequirementsThreadCountDescription' => 'Enter the number of threads required. Thread count must be selected as a required value for this to be included. Select the type of comparison for threads.',
    'ougcAwardsControlPanelNewTaskRequirementsForumPostCount' => 'Forum Post Count',
    'ougcAwardsControlPanelNewTaskRequirementsForumPostCountDescription' => 'Enter the number of posts required in the selected forum. Forum post count must be selected as a required value for this to be included. Select the type of comparison for posts.',
    'ougcAwardsControlPanelNewTaskRequirementsForumThreadCount' => 'Forum Thread Count',
    'ougcAwardsControlPanelNewTaskRequirementsForumThreadCountDescription' => 'Enter the number of threads required in the selected forum. Forum thread count must be selected as a required value for this to be included. Select the type of comparison for threads.',
    'ougcAwardsControlPanelNewTaskRequirementsTimeRegistered' => 'Time Registered',
    'ougcAwardsControlPanelNewTaskRequirementsTimeRegisteredDescription' => 'Enter the number of hours, days, weeks, months, or years that this user must have been registered for. Time registered must be selected as a required value for this to be included. Select whether the time registered should be counted in hours, days, weeks, months, or years.',
    'ougcAwardsControlPanelNewTaskRequirementsTimeOnline' => 'Time Online',
    'ougcAwardsControlPanelNewTaskRequirementsTimeOnlineDescription' => 'Enter the number of hours, days, weeks, months, or years that this user must have been online for. Time online must be selected as a required value for this to be included. Select whether the time spend online should be counted in hours, days, weeks, months, or years.',
    'ougcAwardsControlPanelNewTaskRequirementsReputation' => 'Reputation Count ',
    'ougcAwardsControlPanelNewTaskRequirementsReputationDescription' => 'Enter the amount of reputation to be required. Reputation must be selected as a required value for this to be included. Select the type of comparison for reputation.',
    'ougcAwardsControlPanelNewTaskRequirementsReferrals' => 'Referral Count',
    'ougcAwardsControlPanelNewTaskRequirementsReferralsDescription' => 'Enter the number of referrals required. Referral count must be selected as a required value for this to be included. Select the type of comparison for referrals.',
    'ougcAwardsControlPanelNewTaskRequirementsWarningPoints' => 'Warning Points',
    'ougcAwardsControlPanelNewTaskRequirementsWarningPointsDescription' => 'Enter the number of warning points required. Warning Points must be selected as a required value for this to be included. Select the type of comparison for warning points.',
    'ougcAwardsControlPanelNewTaskRequirementsPreviousAwards' => 'Previous Awards',
    'ougcAwardsControlPanelNewTaskRequirementsPreviousAwardsDescription' => 'Enter the awards required. Previous awards must be selected as a required value for this to be included.',
    'ougcAwardsControlPanelNewTaskRequirementsFilledProfileFields' => 'Filled Profile Fields',
    'ougcAwardsControlPanelNewTaskRequirementsFilledProfileFieldsDescription' => 'Enter the filled profile fields required. Filled profile fields must be selected as a required value for this to be included.',
    //'ougcAwardsControlPanelNewTaskRequirementsMyArcadeChampions' => 'MyDownloads Files Count',
    //'ougcAwardsControlPanelNewTaskRequirementsMyArcadeChampionsDescription' => 'Enter the number of MyDownloads files required. MyDownloads files count must be selected as a required value for this to be included. Select the type of comparison for MyDownloads files.',
    //'ougcAwardsControlPanelNewTaskRequirementsMyArcadeChampions' => 'MyDownloads Files Count',
    //'ougcAwardsControlPanelNewTaskRequirementsMyArcadeScores' => 'MyArcade Score Count',
    //'ougcAwardsControlPanelNewTaskRequirementsMyArcadeScoresDescription' => 'Enter the number of MyArcade Score required. MyArcade score count must be selected as a required value for this to be included. Select the type of comparison for MyArcade score.',
    'ougcAwardsControlPanelNewTaskRequirementsCustomReputationReceived' => 'Custom Reputation Received',
    'ougcAwardsControlPanelNewTaskRequirementsCustomReputationGiven' => 'Custom Reputation Received',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScripts' => 'Custom Field: JSON Script',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScriptsDescription' => 'JSON compatible script to set complex promotion verifications. <a href="https://github.com/OUGC-Network/OUGC-Awards" target="_blank">Read the documentation</a> for more on this.',
    'ougcAwardsControlPanelNewTaskRequirementsRuleScriptsDescriptionPlaceHolder' => '{
	"whereClauses":[
		{
			"tableName":"threads",
			"columnName":"tid",
			"columnValue":3,
			"columnOperator":">=",
			"aggregateFunction":"COUNT",
			"aggregateAlias":"totalThreads"
		},
		{
			"tableName":"threads",
			"columnName":"visible",
			"columnValue":1,
			"columnOperator":"="
		},
		{
			"tableName":"forums",
			"columnName":"fid",
			"columnValue":[
				2,
				30
			],
			"columnOperator":"IN",
			"relationMainField":"ougcCustomPromotionFieldTable_threads.fid",
			"relationSecondaryField":"fid"
		}
	],
	"logicalOperator":"AND"
}',
    //'ougcAwardsControlPanelNewTaskRequirementsNewpoints' => 'Newpoints Points',
    //'ougcAwardsControlPanelNewTaskRequirementsNewpointsDescription' => 'Enter the number of Newpoints points required. Newpoints points must be selected as a required value for this to be included. Select the type of comparison for Newpoints points.',

    'ougcAwardsControlPanelDeleteTaskTableTitle' => 'Delete Task',
    'ougcAwardsControlPanelDeleteTaskTableButton' => 'Delete Task',
    'ougcAwardsControlPanelDeleteTaskTableDescription' => 'Are you sure you want to delete the selected task?',

    'ougcAwardsControlPanelGreaterThan' => 'Greater than',
    'ougcAwardsControlPanelGreaterThanOrEqualTo' => 'Greater than or equal to',
    'ougcAwardsControlPanelEqualTo' => 'Equal to',
    'ougcAwardsControlPanelNotEqualTo' => 'Not equal to',
    'ougcAwardsControlPanelLessThanOrEqualTo' => 'Less than or equal to',
    'ougcAwardsControlPanelLessThan' => 'Less than',

    'ougcAwardsControlPanelHours' => 'Hours',
    'ougcAwardsControlPanelDays' => 'Days',
    'ougcAwardsControlPanelWeeks' => 'Weeks',
    'ougcAwardsControlPanelMonths' => 'Months',
    'ougcAwardsControlPanelYears' => 'Years',

    'ougcAwardsControlPanelNewTaskGrant' => 'Grant Award',
    'ougcAwardsControlPanelNewTaskGrantDescription' => 'Select the award to grant to users.',
    'ougcAwardsControlPanelNewTaskReason' => 'Grant Reason',
    'ougcAwardsControlPanelNewTaskReasonDescription' => 'Select a reason for granting this award.',
    'ougcAwardsControlPanelNewTaskThread' => 'Grant Thread',
    'ougcAwardsControlPanelNewTaskThreadDescription' => 'Please enter a thread to assign to award grants.',
    'ougcAwardsControlPanelNewTaskMultiple' => 'Allow Multiple Awards',
    'ougcAwardsControlPanelNewTaskMultipleDescription' => 'Select whether this task should grant awards to users that already have it.',
    'ougcAwardsControlPanelNewTaskRevoke' => 'Revoke Award',
    'ougcAwardsControlPanelNewTaskRevokeDescription' => 'Select the award to revoke from users.',
    'ougcAwardsControlPanelNewTaskDisplayOrder' => 'Display Order',
    'ougcAwardsControlPanelNewTaskDisplayOrderDescription' => 'Select the display order for this task.',
    'ougcAwardsControlPanelNewTaskButton' => 'Create Task',

    'ougcAwardsControlPanelEditTaskTitle' => 'Edit Tasks',
    'ougcAwardsControlPanelEditTaskTableTitle' => 'Edit Task',
    'ougcAwardsControlPanelEditTaskTableDescription' => 'Use the form below to update an award task.',
    'ougcAwardsControlPanelEditTaskButton' => 'Update Task',

    'ougcAwardsErrorInvalidCategory' => 'The selected category is invalid.',
    'ougcAwardsErrorInvalidAward' => 'The selected award does not exist.',
    'ougcAwardsErrorInvalidTask' => 'The selected task does not exist.',
    'ougcAwardsErrorInvalidOwner' => 'The selected award owner does not exist.',
    'ougcAwardsErrorInvalidUsers' => 'Some selected users do not exist.',
    'ougcAwardsErrorDuplicatedCategoryOwner' => 'Some selected users are already assigned as owners for this category.',
    'ougcAwardsErrorDuplicatedOwner' => 'Some selected users are already assigned as owners for this award.',
    'ougcAwardsErrorPendingRequest' => 'You already have an open request for this award.',
    'ougcAwardsErrorInvalidGrant' => 'The selected award grant does not exist.',
    'ougcAwardsErrorInvalidGrantReason' => 'The selected grant reason is invalid.',
    'ougcAwardsErrorInvalidGrantDate' => 'The selected grant date is invalid.',
    'ougcAwardsErrorInvalidThread' => 'The selected thread does not exist.',
    'ougcAwardsErrorInvalidCategoryName' => 'The selected category name is invalid.',
    'ougcAwardsErrorInvalidCategoryDescription' => 'The selected category description is invalid.',
    'ougcAwardsErrorInvalidAwardName' => 'The selected award name is invalid.',
    'ougcAwardsErrorInvalidAwardDescription' => 'The selected award description is invalid.',
    'ougcAwardsErrorInvalidAwardImage' => 'The selected award image is invalid.',

    'ougcAwardsErrorInvalidTaskName' => 'The selected task name is invalid.',
    'ougcAwardsErrorInvalidTaskDescription' => 'The selected task description is invalid.',
    'ougcAwardsErrorInvalidTaskScript' => 'The selected JSON Script is invalid.',

    'ougcAwardsErrorNoUsersPermission' => 'You have no permission to edit the selected user.',

    'ougcAwardsRedirectMyAwardsUpdated' => 'Your awards were updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectCategoryCreated' => 'The category was created successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectCategoryUpdated' => 'The category was updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectCategoryDeleted' => 'The category was deleted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectAwardCreated' => 'The award was created successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectAwardUpdated' => 'The award was updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectAwardDeleted' => 'The award was deleted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectCategoryOwnerAssigned' => 'The category owner was assigned successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectOwnerAssigned' => 'The award owner was assigned successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectCategoryOwnerRevoked' => 'The category owner was revoked successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectOwnerRevoked' => 'The award owner was revoked successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectGranted' => 'The award was granted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectGrantedUpdated' => 'The award grant was updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectGrantRevokedMultiple' => 'The selected award grants were revoked successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectGrantRevoked' => 'The award grant was revoked successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectPresetCreated' => 'The award preset was created successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectPresetUpdated' => 'The award preset was updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectPresetDeleted' => 'The award preset was deleted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectLogDeleted' => 'The task log was deleted successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectLogsDeleted' => 'The task logs were deleted successfully.<br />You will now be redirected back.',

    'ougcAwardsRedirectRequest' => 'The award request was sent successfully.',

    'ougcAwardsRedirectTaskCreated' => 'The task was created successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectTaskUpdated' => 'The task was updated successfully.<br />You will now be redirected back.',
    'ougcAwardsRedirectTaskDeleted' => 'The task was deleted successfully.<br />You will now be redirected back.',

    'ougcAwardsPrivateMessageTitle' => 'You have been granted the {1} award!',
    'ougcAwardsPrivateMessageRequestRejectedTitle' => 'Your request for the {1} award was rejected.',
    'ougcAwardsPrivateMessageRequestRejectedBody' => 'Hi {1}. This is an automatic message to inform you that your request for the {2} award was rejected.

Greetings.',

    'ougcAwardsTaskRan' => 'The awards task ran successfully.',

    'ougcAwardsPostTitle' => "{1}'s Awards",
    'ougcAwardsPostTitleSection' => "{1}'s Awards In {2}",
    'ougcAwardsPostViewAll' => 'View All',
    'ougcAwardsPostPresetsTitle' => 'Awards',
    'ougcAwardsProfilePresetsTitle' => 'Awards',
    'ougcAwardsWhoIsOnlineViewing' => 'Viewing <a href="{1}/awards.php">Awards Page</a>',

    'ougcAwardsStatsMostTitle' => 'Most Granted Users',
    'ougc_awards_stats_last' => 'Latest Granted',
    'ougc_awards_stats_empty' => 'There are currently no stats to display.',
    'ougcAwardsStatsUser' => 'User',
    'ougcAwardsStatsTotal' => 'Total',

    'ougcAwardsGlobalNotificationRequests' => '<strong>Award Request:</strong> <a href="{1}/{2}">There is one award request pending for review.</a>',
    'ougcAwardsGlobalNotificationRequestsPlural' => '<strong>Award Request:</strong> <a href="{1}/{2}">There are {3} award requests pending for review.</a>',

    'ougcAwardsProfileViewAll' => 'View All',
    'ougcAwardsProfileTitle' => "{1}'s Awards",
    'ougcAwardsProfileTitleSection' => "{1}'s Awards In {2}",
    'ougcAwardsProfileEmpty' => 'There are currently no awards to display.',
    'ougcAwardsViewUser' => 'View User Awards',
    'ougcAwardsViewUserTitle' => "{1}'s Awards",
    'ougcAwardsViewUserEmpty' => 'There are currently no awards to display.',
    'ougcAwardsMyAlerts' => '{2} has granted you the {3} award.',

    'ougcAwardsGlobalAllCategories' => 'All Categories',

    // {4} outputs the award formatted image
    'myalerts_setting_ougc_awards' => 'Receive alert when an award is granted or an award request is rejected?',

    'ougcAwardsDvzStream' => 'Granted Awards',
    'ougcAwardsDvzStreamEvent' => 'Granted Award',
    'ougcAwardsDvzStreamTextUser' => 'Was granted the "{1}" award.',
];